/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents drawing region")
public class Tile {
    @SerializedName(value="startPointX")
    private Integer startPointX = null;
    @SerializedName(value="startPointY")
    private Integer startPointY = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;

    public Tile startPointX(Integer startPointX) {
        this.startPointX = startPointX;
        return this;
    }

    @ApiModelProperty(required=true, value="The X coordinate of the lowest left point on the drawing where the tile begins")
    public Integer getStartPointX() {
        return this.startPointX;
    }

    public void setStartPointX(Integer startPointX) {
        this.startPointX = startPointX;
    }

    public Tile startPointY(Integer startPointY) {
        this.startPointY = startPointY;
        return this;
    }

    @ApiModelProperty(required=true, value="The Y coordinate of the lowest left point on the drawing where the tile begins")
    public Integer getStartPointY() {
        return this.startPointY;
    }

    public void setStartPointY(Integer startPointY) {
        this.startPointY = startPointY;
    }

    public Tile width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="The width of the tile in pixels")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Tile height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="The height of the tile in pixels")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tile tile = (Tile)o;
        return Objects.equals(this.startPointX, tile.startPointX) && Objects.equals(this.startPointY, tile.startPointY) && Objects.equals(this.width, tile.width) && Objects.equals(this.height, tile.height);
    }

    public int hashCode() {
        return Objects.hash(this.startPointX, this.startPointY, this.width, this.height);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tile {\n");
        sb.append("    startPointX: ").append(this.toIndentedString(this.startPointX)).append("\n");
        sb.append("    startPointY: ").append(this.toIndentedString(this.startPointY)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

