/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.viewer.model.FileInfo;
import com.groupdocs.cloud.viewer.model.RenderOptions;
import com.groupdocs.cloud.viewer.model.Watermark;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="View options")
public class ViewOptions {
    @SerializedName(value="fileInfo")
    private FileInfo fileInfo = null;
    @SerializedName(value="viewFormat")
    private ViewFormatEnum viewFormat = null;
    @SerializedName(value="outputPath")
    private String outputPath = null;
    @SerializedName(value="fontsPath")
    private String fontsPath = null;
    @SerializedName(value="watermark")
    private Watermark watermark = null;
    @SerializedName(value="renderOptions")
    private RenderOptions renderOptions = null;

    public ViewOptions fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    @ApiModelProperty(value="File info")
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public ViewOptions viewFormat(ViewFormatEnum viewFormat) {
        this.viewFormat = viewFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="View format (HTML, PNG, JPG, or PDF) Default value is HTML.")
    public ViewFormatEnum getViewFormat() {
        return this.viewFormat;
    }

    public void setViewFormat(ViewFormatEnum viewFormat) {
        this.viewFormat = viewFormat;
    }

    public ViewOptions outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @ApiModelProperty(value="The output path Default value is 'viewer\\{input file path}_{file extension}\\'")
    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public ViewOptions fontsPath(String fontsPath) {
        this.fontsPath = fontsPath;
        return this;
    }

    @ApiModelProperty(value="The path to directory containing custom fonts in storage")
    public String getFontsPath() {
        return this.fontsPath;
    }

    public void setFontsPath(String fontsPath) {
        this.fontsPath = fontsPath;
    }

    public ViewOptions watermark(Watermark watermark) {
        this.watermark = watermark;
        return this;
    }

    @ApiModelProperty(value="Text watermark")
    public Watermark getWatermark() {
        return this.watermark;
    }

    public void setWatermark(Watermark watermark) {
        this.watermark = watermark;
    }

    public ViewOptions renderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options")
    public RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewOptions viewOptions = (ViewOptions)o;
        return Objects.equals(this.fileInfo, viewOptions.fileInfo) && Objects.equals((Object)this.viewFormat, (Object)viewOptions.viewFormat) && Objects.equals(this.outputPath, viewOptions.outputPath) && Objects.equals(this.fontsPath, viewOptions.fontsPath) && Objects.equals(this.watermark, viewOptions.watermark) && Objects.equals(this.renderOptions, viewOptions.renderOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileInfo, this.viewFormat, this.outputPath, this.fontsPath, this.watermark, this.renderOptions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewOptions {\n");
        sb.append("    fileInfo: ").append(this.toIndentedString(this.fileInfo)).append("\n");
        sb.append("    viewFormat: ").append(this.toIndentedString((Object)this.viewFormat)).append("\n");
        sb.append("    outputPath: ").append(this.toIndentedString(this.outputPath)).append("\n");
        sb.append("    fontsPath: ").append(this.toIndentedString(this.fontsPath)).append("\n");
        sb.append("    watermark: ").append(this.toIndentedString(this.watermark)).append("\n");
        sb.append("    renderOptions: ").append(this.toIndentedString(this.renderOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ViewFormatEnum {
        HTML("HTML"),
        PNG("PNG"),
        JPG("JPG"),
        PDF("PDF");

        private String value;

        private ViewFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ViewFormatEnum fromValue(String text) {
            for (ViewFormatEnum b : ViewFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ViewFormatEnum> {
            public void write(JsonWriter jsonWriter, ViewFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ViewFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ViewFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

