/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Text watermark")
public class Watermark {
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="color")
    private String color = null;
    @SerializedName(value="position")
    private PositionEnum position = null;
    @SerializedName(value="size")
    private Integer size = null;

    public Watermark text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Watermark text.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Watermark color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="Watermark color. Supported formats {Magenta|(112,222,11)|(50,112,222,11)}. Default value is \"Red\".")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Watermark position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark position. Default value is \"Diagonal\".")
    public PositionEnum getPosition() {
        return this.position;
    }

    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public Watermark size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark size in percents. Default value is 100.")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Watermark watermark = (Watermark)o;
        return Objects.equals(this.text, watermark.text) && Objects.equals(this.color, watermark.color) && Objects.equals((Object)this.position, (Object)watermark.position) && Objects.equals(this.size, watermark.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.color, this.position, this.size});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Watermark {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PositionEnum {
        DIAGONAL("Diagonal"),
        TOPLEFT("TopLeft"),
        TOPCENTER("TopCenter"),
        TOPRIGHT("TopRight"),
        BOTTOMLEFT("BottomLeft"),
        BOTTOMCENTER("BottomCenter"),
        BOTTOMRIGHT("BottomRight");

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PositionEnum fromValue(String text) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PositionEnum> {
            public void write(JsonWriter jsonWriter, PositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PositionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

