/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="This rendering options enables you to customize the appearance of the output HTML/PDF/PNG/JPEG when rendering Web documents.")
public class WebDocumentOptions {
    @SerializedName(value="pageSize")
    private PageSizeEnum pageSize = null;
    @SerializedName(value="leftMargin")
    private Double leftMargin = null;
    @SerializedName(value="rightMargin")
    private Double rightMargin = null;
    @SerializedName(value="topMargin")
    private Double topMargin = null;
    @SerializedName(value="bottomMargin")
    private Double bottomMargin = null;

    public WebDocumentOptions pageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(required=true, value="The size of the output page. The default value is GroupDocs.Viewer.Options.PageSize.Letter 792 x 612 points. When contents does not fit set a larger page size e.g. GroupDocs.Viewer.Options.PageSize.A3.             ")
    public PageSizeEnum getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
    }

    public WebDocumentOptions leftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    @ApiModelProperty(required=true, value="The distance (in points) between the left edge of the page and the left boundary  of the body text. The default value is 5 points.")
    public Double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public WebDocumentOptions rightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @ApiModelProperty(required=true, value="The distance (in points) between the right edge of the page and the right boundary of the body text. The default value is 5 points.")
    public Double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    public WebDocumentOptions topMargin(Double topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    @ApiModelProperty(required=true, value="The distance (in points) between the top edge of the page and the top boundary of the body text. The default value is 72 points.")
    public Double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(Double topMargin) {
        this.topMargin = topMargin;
    }

    public WebDocumentOptions bottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    @ApiModelProperty(required=true, value="The distance (in points) between the bottom edge of the page and the bottom boundary of the body text. The default value is 72 points.")
    public Double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDocumentOptions webDocumentOptions = (WebDocumentOptions)o;
        return Objects.equals((Object)this.pageSize, (Object)webDocumentOptions.pageSize) && Objects.equals(this.leftMargin, webDocumentOptions.leftMargin) && Objects.equals(this.rightMargin, webDocumentOptions.rightMargin) && Objects.equals(this.topMargin, webDocumentOptions.topMargin) && Objects.equals(this.bottomMargin, webDocumentOptions.bottomMargin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageSize, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebDocumentOptions {\n");
        sb.append("    pageSize: ").append(this.toIndentedString((Object)this.pageSize)).append("\n");
        sb.append("    leftMargin: ").append(this.toIndentedString(this.leftMargin)).append("\n");
        sb.append("    rightMargin: ").append(this.toIndentedString(this.rightMargin)).append("\n");
        sb.append("    topMargin: ").append(this.toIndentedString(this.topMargin)).append("\n");
        sb.append("    bottomMargin: ").append(this.toIndentedString(this.bottomMargin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageSizeEnum {
        UNSPECIFIED("Unspecified"),
        LETTER("Letter"),
        LEDGER("Ledger"),
        A0("A0"),
        A1("A1"),
        A2("A2"),
        A3("A3"),
        A4("A4");

        private String value;

        private PageSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageSizeEnum fromValue(String text) {
            for (PageSizeEnum b : PageSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageSizeEnum> {
            public void write(JsonWriter jsonWriter, PageSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

