/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.viewer.model.Character;
import com.groupdocs.cloud.viewer.model.TextElement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents relatively positioned rectangle which contains single word")
public class Word
extends TextElement {
    @SerializedName(value="characters")
    private List<Character> characters = null;

    public Word characters(List<Character> characters) {
        this.characters = characters;
        return this;
    }

    public Word addCharactersItem(Character charactersItem) {
        if (this.characters == null) {
            this.characters = new ArrayList<Character>();
        }
        this.characters.add(charactersItem);
        return this;
    }

    @ApiModelProperty(value="The characters contained by the word")
    public List<Character> getCharacters() {
        return this.characters;
    }

    public void setCharacters(List<Character> characters) {
        this.characters = characters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Word word = (Word)o;
        return Objects.equals(this.characters, word.characters) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.characters, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Word {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    characters: ").append(this.toIndentedString(this.characters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

