/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Provides options for rendering word processing documents")
public class WordProcessingOptions {
    @SerializedName(value="renderTrackedChanges")
    private Boolean renderTrackedChanges = null;
    @SerializedName(value="leftMargin")
    private Double leftMargin = null;
    @SerializedName(value="rightMargin")
    private Double rightMargin = null;
    @SerializedName(value="topMargin")
    private Double topMargin = null;
    @SerializedName(value="bottomMargin")
    private Double bottomMargin = null;
    @SerializedName(value="pageSize")
    private PageSizeEnum pageSize = null;
    @SerializedName(value="enableOpenTypeFeatures")
    private Boolean enableOpenTypeFeatures = null;
    @SerializedName(value="unlinkTableOfContents")
    private Boolean unlinkTableOfContents = null;
    @SerializedName(value="updateFields")
    private Boolean updateFields = null;

    public WordProcessingOptions renderTrackedChanges(Boolean renderTrackedChanges) {
        this.renderTrackedChanges = renderTrackedChanges;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables tracked changes (revisions) rendering")
    public Boolean getRenderTrackedChanges() {
        return this.renderTrackedChanges;
    }

    public void setRenderTrackedChanges(Boolean renderTrackedChanges) {
        this.renderTrackedChanges = renderTrackedChanges;
    }

    public WordProcessingOptions leftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    @ApiModelProperty(required=true, value="Left page margin (for HTML rendering only)")
    public Double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public WordProcessingOptions rightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @ApiModelProperty(required=true, value="Right page margin (for HTML rendering only)")
    public Double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    public WordProcessingOptions topMargin(Double topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    @ApiModelProperty(required=true, value="Top page margin (for HTML rendering only)")
    public Double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(Double topMargin) {
        this.topMargin = topMargin;
    }

    public WordProcessingOptions bottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    @ApiModelProperty(required=true, value="Bottom page margin (for HTML rendering only)")
    public Double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public WordProcessingOptions pageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(required=true, value="The size of the page.")
    public PageSizeEnum getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
    }

    public WordProcessingOptions enableOpenTypeFeatures(Boolean enableOpenTypeFeatures) {
        this.enableOpenTypeFeatures = enableOpenTypeFeatures;
        return this;
    }

    @ApiModelProperty(required=true, value="This option enables kerning and other OpenType Features when rendering Arabic, Hebrew, Indian Latin-based, or Cyrillic-based scripts.")
    public Boolean getEnableOpenTypeFeatures() {
        return this.enableOpenTypeFeatures;
    }

    public void setEnableOpenTypeFeatures(Boolean enableOpenTypeFeatures) {
        this.enableOpenTypeFeatures = enableOpenTypeFeatures;
    }

    public WordProcessingOptions unlinkTableOfContents(Boolean unlinkTableOfContents) {
        this.unlinkTableOfContents = unlinkTableOfContents;
        return this;
    }

    @ApiModelProperty(required=true, value="When rendering to HTML or PDF, you can set this option to `true` to disable navigation from the table of contents. For HTML rendering, `a` tags with relative links will be replaced with `span` tags, removing functionality but preserving visual appearance. For PDF rendering, the table of contents will be rendered as plain text without links to document sections.             ")
    public Boolean getUnlinkTableOfContents() {
        return this.unlinkTableOfContents;
    }

    public void setUnlinkTableOfContents(Boolean unlinkTableOfContents) {
        this.unlinkTableOfContents = unlinkTableOfContents;
    }

    public WordProcessingOptions updateFields(Boolean updateFields) {
        this.updateFields = updateFields;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines if fields of certain types should be updated before saving the input WordProcessing document to the HTML, PDF, PNG, or JPEG output formats. Default value for this property is true \u2014 fields will be updated before saving.             ")
    public Boolean getUpdateFields() {
        return this.updateFields;
    }

    public void setUpdateFields(Boolean updateFields) {
        this.updateFields = updateFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordProcessingOptions wordProcessingOptions = (WordProcessingOptions)o;
        return Objects.equals(this.renderTrackedChanges, wordProcessingOptions.renderTrackedChanges) && Objects.equals(this.leftMargin, wordProcessingOptions.leftMargin) && Objects.equals(this.rightMargin, wordProcessingOptions.rightMargin) && Objects.equals(this.topMargin, wordProcessingOptions.topMargin) && Objects.equals(this.bottomMargin, wordProcessingOptions.bottomMargin) && Objects.equals((Object)this.pageSize, (Object)wordProcessingOptions.pageSize) && Objects.equals(this.enableOpenTypeFeatures, wordProcessingOptions.enableOpenTypeFeatures) && Objects.equals(this.unlinkTableOfContents, wordProcessingOptions.unlinkTableOfContents) && Objects.equals(this.updateFields, wordProcessingOptions.updateFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.renderTrackedChanges, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.pageSize, this.enableOpenTypeFeatures, this.unlinkTableOfContents, this.updateFields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WordProcessingOptions {\n");
        sb.append("    renderTrackedChanges: ").append(this.toIndentedString(this.renderTrackedChanges)).append("\n");
        sb.append("    leftMargin: ").append(this.toIndentedString(this.leftMargin)).append("\n");
        sb.append("    rightMargin: ").append(this.toIndentedString(this.rightMargin)).append("\n");
        sb.append("    topMargin: ").append(this.toIndentedString(this.topMargin)).append("\n");
        sb.append("    bottomMargin: ").append(this.toIndentedString(this.bottomMargin)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString((Object)this.pageSize)).append("\n");
        sb.append("    enableOpenTypeFeatures: ").append(this.toIndentedString(this.enableOpenTypeFeatures)).append("\n");
        sb.append("    unlinkTableOfContents: ").append(this.toIndentedString(this.unlinkTableOfContents)).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.updateFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageSizeEnum {
        UNSPECIFIED("Unspecified"),
        LETTER("Letter"),
        LEDGER("Ledger"),
        A0("A0"),
        A1("A1"),
        A2("A2"),
        A3("A3"),
        A4("A4");

        private String value;

        private PageSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageSizeEnum fromValue(String text) {
            for (PageSizeEnum b : PageSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageSizeEnum> {
            public void write(JsonWriter jsonWriter, PageSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

