/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model.requests;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.util.Objects;

public class ConvertAndDownloadRequest {
    @SerializedName(value="format")
    private String format = null;
    @SerializedName(value="file")
    private File file = null;
    @SerializedName(value="pages")
    private String pages = null;
    @SerializedName(value="password")
    private String password = null;

    public ConvertAndDownloadRequest() {
    }

    public ConvertAndDownloadRequest(String format, File file, String pages, String password) {
        this.format = format;
        this.file = file;
        this.pages = pages;
        this.password = password;
    }

    @ApiModelProperty(example="format_example", required=true, value="Requested conversion format: HTML, JPG, PNG or PDF")
    public String getformat() {
        return this.format;
    }

    public void setformat(String format) {
        this.format = format;
    }

    @ApiModelProperty(example="new File(&quot;/path/to/file.txt&quot;)", required=true, value="Input file to convert")
    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @ApiModelProperty(example="pages_example", value="Pages range to render, like \"1,2\" or \"3-5,10\"")
    public String getpages() {
        return this.pages;
    }

    public void setpages(String pages) {
        this.pages = pages;
    }

    @ApiModelProperty(example="password_example", value="Input document password")
    public String getpassword() {
        return this.password;
    }

    public void setpassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertAndDownloadRequest request = (ConvertAndDownloadRequest)o;
        return Objects.equals(this.format, request.format) && Objects.equals(this.file, request.file) && Objects.equals(this.pages, request.pages) && Objects.equals(this.password, request.password);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.file, this.pages, this.password);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConvertAndDownload {\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    file: ").append(this.toIndentedString(this.file)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

